package ru.yandex.wmtools.common.framework.http;

import ru.yandex.common.framework.core.RedirectChecker;
import ru.yandex.common.framework.core.XmlBuilder;
import ru.yandex.common.framework.http.HttpServResponse;

import javax.servlet.http.HttpServletResponse;

/**
 * @author avhaliullin
 */
public class WMHttpServResponse extends HttpServResponse {
    private ServResponseStatus status = ServResponseStatus.SUCCESS;

    public WMHttpServResponse(HttpServletResponse response, XmlBuilder xmlBuilder, RedirectChecker redirectChecker) {
        super(response, xmlBuilder, redirectChecker);
    }

    public void errorHappened(ServResponseStatus errorStatus) {
        if (errorStatus.getSeverity() > status.getSeverity()) {
            status = errorStatus;
        }
    }

    public ServResponseStatus getStatus() {
        return status;
    }
}
