package ru.yandex.wmtools.common.servantlet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmtools.common.error.CodeErrorInfo;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.service.SettingsService;

/**
 * @author baton
 */
@Deprecated
public abstract class HttpAbstractServantlet extends AbstractServantlet {
    private static final Logger log = LoggerFactory.getLogger(HttpAbstractServantlet.class);

    private SettingsService settingsService;
    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    private final UserTextOptions userTextOptions = new UserTextOptions();

    @Override
    public final void process(ServRequest req, ServResponse res) {
        try {
            doProcess(req, res);
        } catch (UserException e) {
            log.warn(getErrorMessage(e), e);

            String userText = userTextOptions.createUserText(e, settingsService);

            res.addErrorInfo(new CodeErrorInfo(e.getProblem(), e.getProblem().getId(), e.getMessage(), userText, e, e.getExtraParams()));
        } catch (InternalException e) {
            log.error(getErrorMessage(e), e);
            throw new RuntimeException(e);
            //todo add user text?
        } catch (Throwable e) {
            log.error(getErrorMessage(e), e);
            throw new RuntimeException(e);
        }
    }
}
