package ru.yandex.wmtools.common.servantlet.top;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.common.util.collections.Pair;
import ru.yandex.common.util.db.OrderByClause;
import ru.yandex.wmtools.common.data.TopQueryHistoryType;
import ru.yandex.wmtools.common.data.info.RegionInfo;
import ru.yandex.wmtools.common.data.info.RegionInfoTreeNode;
import ru.yandex.wmtools.common.data.info.TopInfo;
import ru.yandex.wmtools.common.data.info.TopInfoItem;
import ru.yandex.wmtools.common.data.info.TopQueryHistoryInfo;
import ru.yandex.wmtools.common.data.info.TotalsInfo;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;
import ru.yandex.wmtools.common.service.RegionsTreeCacheService;
import ru.yandex.wmtools.common.service.TopInfoService;

abstract public class WMToolsTopQueryHistoryServantlet
        <HostInfoType, TI extends TopInfo, TII extends TopInfoItem, TTL extends TotalsInfo>
        extends AuthenticationServantlet {
    public static final String TOP_QUERY_HISTORY_PLOT_NAME = "top_query_history";
    public static final String TOP_QUERY_CTR_HISTORY_PLOT_NAME = "top_query_ctr_history";
    public static final String TOP_QUERY_POSITION_HISTORY_PLOT_NAME = "top_query_position_history";
    public static final String TOP_QUERY_PART_HISTORY_PLOT_NAME = "top_query_part_history";

    abstract protected TopInfoService<HostInfoType, TI, TII, TTL> getTopInfoService();
    abstract protected RegionsTreeCacheService getRegionsTreeCacheService();
    abstract protected HostInfoType getHostInfoType(ServRequest req, ServResponse res, long userId) throws UserException, InternalException;
    abstract protected Date getShiftedDate(ServRequest req) throws UserException;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        HostInfoType hostInfoType = getHostInfoType(req, res, userId);

        Boolean includeSubregions = getIncludeSubregions(req);
        includeSubregions = includeSubregions == null ? WMToolsQueriesInfoServantlet.INCLUDE_SUBREGIONS_BY_DEFAULT : includeSubregions;

        Integer region = getRegionParam(req);
        if (region == null || region < 0) {
            region = 0;
        }

        List<Long> selectedQueryIds = getSelectedQueryIds(req);

        Date date = getTopInfoService().getLatestInfoDateIfDateIsNull(region, hostInfoType, getShiftedDate(req), includeSubregions);

        Map<Date, List<RegionInfo>> keyRegionsForDate = getTopInfoService().getKeyRegionsForAllTime(hostInfoType);
        List<RegionInfo> keyRegions = keyRegionsForDate.get(date);
        if (keyRegions == null) {
            keyRegions = new ArrayList<RegionInfo>();
        }

        //TODO: КОСТЫЛЬ!!!
        List<RegionInfo> list = new ArrayList<RegionInfo>(keyRegions);
        for (Iterator<RegionInfo> i = list.iterator(); i.hasNext();) {
            int reg = i.next().getId();
            if (reg == 0 || reg == 10000) {
                i.remove();
            }
        }

        List<RegionInfoTreeNode> tree = getRegionsTreeCacheService().getTreeWithCountries(list);

        TopQueryHistoryType type = getTypeParam(req);

        List<TopQueryHistoryInfo> selectedQueriesInfoList = getTopInfoService().getQueriesHistoryInfo(region,
                type.getTopQueryHistoryTypeEnum(),
                keyRegions,
                hostInfoType,
                WMToolsQueriesInfoServantlet.HISTORY_LENGTH,
                includeSubregions,
                selectedQueryIds,
                keyRegionsForDate);

        Pager pager = getOutputStrategy().createPager();

        List<Date> dates = getTopInfoService().getKeyRegionsChangeDates(keyRegionsForDate);
        dates.add(new Date());
        List<Pair<Date, Date>> intervals = new ArrayList<Pair<Date, Date>>();
        for (int i = 0; i < dates.size() - 1; i++) {
            Calendar left = Calendar.getInstance();
            if (i == 0) {
                left.setTime(dates.get(i));
                left.add(Calendar.DATE, -6);
            } else {
                left.setTime(intervals.get(i - 1).getSecond());
                left.add(Calendar.DATE, 1);
            }

            Calendar right = Calendar.getInstance();
            if (i == dates.size() - 2) {
                right.setTime(dates.get(i + 1));
            } else {
                right.setTime(dates.get(i + 1));
                right.add(Calendar.DATE, -7);
            }
            intervals.add(new Pair<Date, Date>(left.getTime(), right.getTime()));
        }

        OrderByClause order = getOrder(req, type);
        List<TopQueryHistoryInfo> historyInfoList = getTopInfoService().getQueriesHistoryInfo(region, type.getTopQueryHistoryTypeEnum(), keyRegions, hostInfoType, WMToolsQueriesInfoServantlet.HISTORY_LENGTH, includeSubregions, order, pager, date);

        for (Iterator<TopQueryHistoryInfo> iter = historyInfoList.iterator(); iter.hasNext();) {
            TopQueryHistoryInfo info = iter.next();
            if (info.getInTopCount() < WMToolsQueriesInfoServantlet.HISTORY_LENGTH) {
                iter.remove();
            }
        }

        outputData(res, tree, selectedQueriesInfoList, pager, intervals, historyInfoList);
    }

    abstract protected OrderByClause getOrder(ServRequest req, TopQueryHistoryType type);

    abstract protected Integer getRegionParam(ServRequest req) throws UserException;

    abstract protected List<Long> getSelectedQueryIds(ServRequest req);

    abstract protected Boolean getIncludeSubregions(ServRequest req);

    abstract protected void outputData(ServResponse res, List<RegionInfoTreeNode> tree, List<TopQueryHistoryInfo> selectedQueriesInfoList, Pager pager, List<Pair<Date, Date>> intervals, List<TopQueryHistoryInfo> historyInfoList);
    abstract protected TopQueryHistoryType getTypeParam(ServRequest req) throws UserException;
}
