package ru.yandex.wmtools.common.service;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;

/**
 * User: baton
 * Date: May 7, 2007
 * Time: 1:59:48 PM
 */
public class CheatViewerUserIdService implements IService, IUserIdService {
    private ISupportService supportService;

    @Override
    public long getAndCheckUserId(final ServRequest req, ServResponse res) throws UserException {
        Long userId = req.getUserId();
        return checkUserId(userId);
    }

    public long checkUserId(final Long userId) throws UserException {
        if (userId == null) {
            throw new UserException(UserProblem.USER_NOT_SIGNED_IN, "User not signed in!");
        }
        return userId;
    }

    public ISupportService getSupportService() {
        return supportService;
    }

    @Required
    public void setSupportService(ISupportService supportService) {
        this.supportService = supportService;
    }
}
