package ru.yandex.wmtools.common.service;

import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.InternalProblem;
import ru.yandex.wmtools.common.error.UserException;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class ConductorService extends AbstractExternalHttpService {
    private static final String GROUPS_2_HOSTS_COMMAND = "groups2hosts/";

    public List<String> groups2hosts(String groupName) throws InternalException, UserException {
        final Map<String, Object> headers = Collections.emptyMap();
        BufferedReader reader = new BufferedReader(httpGetResponseReader(GROUPS_2_HOSTS_COMMAND + groupName, createParams(), CONNECTION_TIMEOUT, headers));
        String line;
        List<String> res = new ArrayList<String>();
        try {
            while ((line = reader.readLine()) != null) {
                res.add(line.trim());
            }
        } catch (IOException e) {
            throw new InternalException(InternalProblem.CONNECTION_PROBLEM, "Failed to connect to conductor", e);
        }
        return res;
    }
}
