package ru.yandex.wmtools.common.service;

import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

import ru.yandex.common.framework.host.HostEnvironment;

/**
 * @author avhaliullin
 */
public class EnvironmentSensitivePlaceholderConfigurer extends PropertyPlaceholderConfigurer {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentSensitivePlaceholderConfigurer.class);

    private HostEnvironment hostEnvironment;

    @Override
    protected String resolvePlaceholder(String placeholder, Properties props) {
        String res = super.resolvePlaceholder(hostEnvironment.current().name() + "." + placeholder, props);
        if (res == null || res.isEmpty()) {
            return super.resolvePlaceholder(placeholder, props);
        }
        return res;
    }

    public void setHostEnvironment(HostEnvironment hostEnvironment) {
        this.hostEnvironment = hostEnvironment;
    }
}
