package ru.yandex.wmtools.common.service;

import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.InternalProblem;
import ru.yandex.wmtools.common.util.geobase.GeobaseNameHandler;
import ru.yandex.wmtools.common.util.geobase.GeobaseRegionInfoHandler;

/**
 * @author avhaliullin
 */
public class GeobaseService extends AbstractExternalHttpService {
    public static final String GEOBASE_FIELDS = "id,name,runame,ukname,enname,trname,kkname,byname";

    public void loadRegionsInfo(GeobaseRegionInfoHandler handler) throws InternalException {
        InputStream res = httpGetResponse("geobase.xml",
                createParams().addParam("fields", GEOBASE_FIELDS),
                10000);

        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        try {
            SAXParser parser = saxParserFactory.newSAXParser();
            parser.parse(new InputSource(res), new GeobaseNameHandler(handler));
        } catch (SAXException e) {
            throw new InternalException(InternalProblem.PROCESSING_ERROR,
                    "Failed to parse geobase response.", e);
        } catch (IOException e) {
            throw new InternalException(InternalProblem.CONNECTION_PROBLEM,
                    "External geobase servant is unavialable. URL: " + externalServantUrl, e);
        } catch (ParserConfigurationException e) {
            throw new InternalException(InternalProblem.PROCESSING_ERROR,
                    "Failed to parse geobase response.", e);
        }
    }
}
