package ru.yandex.wmtools.common.service;

import ru.yandex.wmtools.common.data.info.WMUserInfo;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

import java.util.Collection;
import java.util.Date;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 20.01.2009
 * Time: 10:54:03
 */
public interface IUserInfoService extends IService {
    WMUserInfo getUserInfo(long userId) throws InternalException, UserException;

    void createNewUser(long userId) throws UserException, InternalException;

    long getAndCheckUserIdByNameOrId(String user, String paramName) throws UserException, InternalException;

    public long getUserIdByNameOrId(String user, String paramName) throws UserException;

    void updateLastVisit(Map.Entry<Long, Date> entry) throws InternalException;

    boolean isKnownUser(long userId) throws InternalException;

    void parseUserList(String userString, Collection<Long> correctUsersList, Collection<String> incorrectUsersList);
}
