package ru.yandex.wmtools.common.service;

import java.io.IOException;
import java.io.Reader;

import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.InternalProblem;

/**
 * @author senin
 * @author ailyin
 */
public class JDomXmlSearchResultParser implements XmlSearchResultParser<Document> {
    @Override
    public Document parseResult(Reader result) throws InternalException {
        try {
            return new SAXBuilder().build(result);
        } catch (IOException e) {
            throw new InternalException(InternalProblem.PROCESSING_ERROR,
                    "IOException in JDomXmlSearchResultParser!", e);
        } catch (JDOMException e) {
            throw new InternalException(InternalProblem.PROCESSING_ERROR,
                    "JDOMException in JDomXmlSearchResultParser!", e);
        }
    }
}
