package ru.yandex.wmtools.common.service;

import ru.yandex.wmtools.common.util.SqlUtil;

import java.util.Date;
import java.util.HashMap;

/**
 * Created by IntelliJ IDEA.
* User: senin
* Date: 05.02.2008
* Time: 20:16:36
*/
public class RequestCountInfo {
    private HashMap<Date, HashMap<Long, Long>> date2users = new HashMap<Date, HashMap<Long, Long>>();

    public void addUserRequest(long userId) {
        Date date = SqlUtil.getMidnightTimestamp(null);
        HashMap<Long, Long> users = date2users.get(date);
        if (users == null) {
            users = new HashMap<Long, Long>();
            date2users.put(date, users);
        }
        Long count = users.get(userId);
        if (count == null) {
            count = 0L;
        }
        users.put(userId, ++count);
    }

    public void visit(IRequestCountInfoVisitor acceptor) {
        for (Date date : date2users.keySet()) {
            HashMap<Long, Long> users = date2users.get(date);
            for (Long userId : users.keySet()) {
                if (!acceptor.accept(date, userId, users.get(userId))) {
                    return;
                }
            }
        }
    }

    public interface IRequestCountInfoVisitor {
        boolean accept(Date date, long userId, long count);
    }
}
