package ru.yandex.wmtools.common.service;

import ru.yandex.common.util.collections.Pair;
import ru.yandex.wmtools.common.error.InternalException;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class SidsBlackboxService extends AbstractBlackboxService {
    private Map<Integer, String> getServiceLogins(Pair<IdentificationMethod, String> idParam, Integer... sids) throws InternalException {
        String[] dbFields = new String[sids.length];
        for (int i = 0; i < sids.length; i++) {
            dbFields[i] = "subscription.login." + sids[i];
        }
        Map<String, String> fieldsMap = parseResponse(getDocument(idParam, Method.USER_INFO, null, Arrays.asList(dbFields)));
        Map<Integer, String> resultMap = new HashMap<Integer, String>();
        for (int i = 0; i < sids.length; i++) {
            if (fieldsMap.containsKey(dbFields[i])) {
                resultMap.put(sids[i], fieldsMap.get(dbFields[i]));
            }
        }
        return resultMap;
    }

    public Map<Integer, String> getServiceLogins(String login, Integer... sids) throws InternalException {
        return getServiceLogins(Pair.of(IdentificationMethod.LOGIN, login), sids);
    }

    public Map<Integer, String> getServiceLogins(long userId, Integer... sids) throws InternalException {
        return getServiceLogins(Pair.of(IdentificationMethod.UID, String.valueOf(userId)), sids);
    }
}
