package ru.yandex.wmtools.common.service;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;

/**
 * User: baton
 * Date: May 7, 2007
 * Time: 1:59:48 PM
 */
public class SupportUserIdService implements IService, IUserIdService {
    private ISupportService supportService;
    private IViewerUserIdService viewerUserIdService;

    @Override
    public long getAndCheckUserId(final ServRequest req, ServResponse res) throws UserException, InternalException {
        long userId = viewerUserIdService.getAndCheckUserId(req, res);

        if (!supportService.isSupportAndNotBlockedUser(userId)) {
            throw new UserException(UserProblem.USER_NOT_PERMITTED, "User " + userId + " is not in list of supports or blocked!");
        }

        return userId;
    }

    @Required
    public void setViewerUserIdService(IViewerUserIdService viewerUserIdService) {
        this.viewerUserIdService = viewerUserIdService;
    }

    @Required
    public void setSupportService(ISupportService supportService) {
        this.supportService = supportService;
    }
}
