package ru.yandex.wmtools.common.service;

import java.util.Comparator;
import java.util.HashMap;

import ru.yandex.common.util.db.OrderByClause;
import ru.yandex.wmtools.common.data.info.TopInfoItem;

/**
 * @author baton
 */
abstract public class TopInfoComparator<T extends TopInfoItem> extends HashMap<String, String> implements Comparator<T> {
    protected final OrderByClause orderBy;

    public TopInfoComparator(OrderByClause orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    abstract public int compare(T o1, T o2);

    abstract protected String getShowsFieldName();

    abstract protected String getClicksFieldName();

    abstract protected String getQueryFieldName();
}
