package ru.yandex.wmtools.common.service;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;

/**
 * User: baton
 * Date: May 7, 2007
 * Time: 1:59:48 PM
 */
public class ViewerUserIdNoAutoRegisterLicenceNotRequiredService implements IService, IViewerUserIdService {
    private ISupportService supportService;
    public void setSupportService(ISupportService supportService) {
        this.supportService = supportService;
    }

    @Override
    public long getAndCheckUserId(final ServRequest req, ServResponse res) throws UserException, InternalException {
        Long userId = checkUserId(req.getUserId());
        assureUserIsInUsersList(req.getUserId());
        checkUserIsNotBlockedAndAcceptedLicence(userId);
        return userId;
    }

    @Override
    public long checkUserId(final Long userId) throws UserException {
        if (userId == null) {
            throw new UserException(UserProblem.USER_NOT_SIGNED_IN, "User not signed in!");
        }
        return userId;
    }

    @Override
    public void assureUserIsInUsersList(long userId) throws UserException, InternalException {
        if (!supportService.isKnownUser(userId)) {
            throw new UserException(UserProblem.NO_SUCH_USER_IN_SERVICE, "User " + userId + " is not registered in service.");
        }
    }

    @Override
    public void checkUserIsNotBlockedAndAcceptedLicence(long userId) throws UserException, InternalException {
        if (supportService.isBlockedUser(userId)) {
            throw new UserException(UserProblem.USER_IS_BLOCKED, "User " + userId + " is blocked.");
        }
//        if (supportService.isUserHaventAcceptedLicence(userId)) {
//            throw new UserException(UserProblem.USER_HAVENT_ACCEPTED_LICENCE, "User " + userId + " haven't accepted licence.");
//        }
    }
}
