package ru.yandex.wmtools.common.service;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;

/**
 * @author baton
 */
public class ViewerUserIdNoUserCheckingService implements IService, IViewerUserIdService {
    @Override
    public long getAndCheckUserId(final ServRequest req, ServResponse res) throws UserException {
        return checkUserId(req.getUserId());
    }

    @Override
    public long checkUserId(final Long userId) throws UserException {
        if (userId == null) {
            throw new UserException(UserProblem.USER_NOT_SIGNED_IN, "User not signed in!");
        }
        return userId;
    }

    @Override
    public void assureUserIsInUsersList(long userId) {
    }

    @Override
    public void checkUserIsNotBlockedAndAcceptedLicence(long userId) {
    }
}
