package ru.yandex.wmtools.common.service;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;

/**
 * User: baton
 * Date: May 7, 2007
 * Time: 1:59:48 PM
 */
public class ViewerUserIdVerySimpleService implements IService, IUserIdService {
    @Override
    public long getAndCheckUserId(final ServRequest req, ServResponse res) throws UserException {
        return checkUserId(req.getUserId());
    }

    public long checkUserId(final Long userId) throws UserException {
        if (userId == null) {
            throw new UserException(UserProblem.USER_NOT_SIGNED_IN, "User not signed in!");
        }
        return userId;
    }
}
