package ru.yandex.wmtools.common.service;

import java.io.Reader;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.InternalProblem;

/**
 * @author senin
 * @author ailyin
 */
public class XPathXmlSearchResultParser implements XmlSearchResultParser<Node> {
    private static final Logger log = LoggerFactory.getLogger(XPathXmlSearchResultParser.class);

    private final String expression;

    public XPathXmlSearchResultParser(String expression) {
        this.expression = expression;
    }

    @Override
    public Node parseResult(Reader result) throws InternalException {
        log.debug("parseResult() started");
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        try {
            Node t = (Node) xPath.evaluate(expression, new InputSource(result), XPathConstants.NODE);
            log.debug("parseResult() finished");
            return t;
        } catch (XPathExpressionException e) {
            throw new InternalException(InternalProblem.PROCESSING_ERROR,
                    "XPathExpressionException in XPathXmlSearchResultParser!", e);
        }
    }
}
