package ru.yandex.wmtools.common.sita;

import org.apache.commons.lang.Validate;

/**
 * @author aherman
 */
public class RedirectConfig {
    private final int maxRedirects;
    private final boolean requireSameOrigin;
    private final boolean requireAbsoluteLocation;

    public static final RedirectConfig DEFAULT_REDIRECT_CONFIG = new RedirectConfig(3, false, false);

    public RedirectConfig(int maxRedirects) {
        this(maxRedirects, false, false);
    }

    public RedirectConfig(int maxRedirects, boolean requireSameOrigin, boolean requireAbsoluteLocation) {
        Validate.isTrue(maxRedirects > 0, "Max redirects must be > 0, now:", maxRedirects);
        this.maxRedirects = maxRedirects;
        this.requireSameOrigin = requireSameOrigin;
        this.requireAbsoluteLocation = requireAbsoluteLocation;
    }

    public int getMaxRedirects() {
        return maxRedirects;
    }

    public boolean isRequireSameOrigin() {
        return requireSameOrigin;
    }

    public boolean isRequireAbsoluteLocation() {
        return requireAbsoluteLocation;
    }
}
