package ru.yandex.wmtools.common.sita;

import java.net.URI;

import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * @author aherman
 */
public interface RedirectListener {
    public void beforeRedirect(URI from, URI to) throws UserException, InternalException;
    public void lastTarget(URI uri) throws UserException, InternalException;

    public static final RedirectListener DEFAULT_LISTENER = new RedirectListener() {
        @Override
        public void beforeRedirect(URI from, URI to) {
        }

        @Override
        public void lastTarget(URI uri) {
        }
    };
}
