package ru.yandex.wmtools.common.sita;

import ru.yandex.wmtools.common.util.enums.IntEnum;
import ru.yandex.wmtools.common.util.enums.IntEnumResolver;

/**
 * User: azakharov
 * Date: 18.03.14
 * Time: 18:53
 */
public enum SitaMirroringActionStatusEnum implements IntEnum {
    OK(0),
    ERROR_INTERNAL(1),
    ERROR_USER(2),
    ERROR_TIMEOUT(3);

    private int id;

    private SitaMirroringActionStatusEnum(int id) {
        this.id = id;
    }

    public static SitaMirroringActionStatusEnum fromString(final String s) {
        for (SitaMirroringActionStatusEnum value : values()) {
            if (value.name().equals(s)) {
                return value;
            }
        }
        return null;
    }

    public int value() {
        return id;
    }

    public static final IntEnumResolver<SitaMirroringActionStatusEnum> R = IntEnumResolver.r(SitaMirroringActionStatusEnum.class);
}
