package ru.yandex.wmtools.common.sita;

import ru.yandex.wmtools.common.util.enums.IntEnum;
import ru.yandex.wmtools.common.util.enums.IntEnumResolver;

/**
 * User: azakharov
 * Date: 18.03.14
 * Time: 19:03
 */
public enum SitaMirroringHostStatusEnum implements IntEnum {
    OK(0),
    ERROR(1),
    ERROR_HOST_NOT_PROCESSED(2),
    ERROR_NOT_UNSTICKED(3),
    ERROR_BAD_HOST_DIRECTIVE_AT_NEW_MAIN(4),
    ERROR_BAD_REAL_MAIN(5);

    private int id;

    private SitaMirroringHostStatusEnum(int id) {
        this.id = id;
    }

    @Override
    public int value() {
        return id;
    }

    public static final IntEnumResolver<SitaMirroringHostStatusEnum> R = IntEnumResolver.r(SitaMirroringHostStatusEnum.class);
}
