package ru.yandex.wmtools.common.sita;

import java.net.URI;
import java.util.List;

/**
 * User: azakharov
 * Date: 18.03.14
 * Time: 14:32
 */
public class SitaMirroringResponse {
    private final SitaMirroringActionStatusEnum status;
    private final List<THostResult> hostResults;

    public SitaMirroringResponse(SitaMirroringActionStatusEnum status, List<THostResult> hostResults) {
        this.status = status;
        this.hostResults = hostResults;
    }

    public SitaMirroringActionStatusEnum getStatus() {
        return status;
    }

    public List<THostResult> getHostResults() {
        return hostResults;
    }

    public static class THostResult {
        private final SitaMirroringHostStatusEnum status;
        private final URI host;
        private final URI newMainMirror;

        public THostResult(SitaMirroringHostStatusEnum status, URI host, URI newMainMirror) {
            this.status = status;
            this.host = host;
            this.newMainMirror = newMainMirror;
        }

        public SitaMirroringHostStatusEnum getStatus() {
            return status;
        }

        public URI getHost() {
            return host;
        }

        public URI getNewMainMirror() {
            return newMainMirror;
        }
    }
}
