package ru.yandex.wmtools.common.sita;

import java.net.URI;

/**
 * @author aherman
 */
public class SitaRedirectCycleException extends SitaException {
    private final URI redirectUri;

    public SitaRedirectCycleException(String message, URI redirectUri) {
        super(message);
        this.redirectUri = redirectUri;
    }

    public SitaRedirectCycleException(String message, URI redirectUri, Throwable cause) {
        super(message, cause);
        this.redirectUri = redirectUri;
    }

    public URI getRedirectUri() {
        return redirectUri;
    }
}
