package ru.yandex.wmtools.common.sita;

import java.net.URI;
import java.util.Collections;
import java.util.List;

/**
 * @author aherman
 */
public class SitaRedirectInfo {
    private final List<URI> redirects;

    public SitaRedirectInfo(List<URI> redirects) {
        this.redirects = redirects;
    }

    public List<URI> getRedirects() {
        return redirects;
    }

    public boolean hasRedirects() {
        return redirects.size() > 1;
    }

    public static final SitaRedirectInfo NO_REDIRECTS = new SitaRedirectInfo(Collections.<URI>emptyList());
}
