package ru.yandex.wmtools.common.sita;

import org.apache.http.HttpResponse;
import org.jetbrains.annotations.NotNull;

/**
 * @author aherman
 */
public class SitaUrlFetchExtendedResponse extends SitaUrlFetchResponse {
    private SitaResponseError sitaResponseError = SitaResponseError.NO_ERROR;

    public SitaUrlFetchExtendedResponse(Boolean allowedInRobotsTxt, Long ip4, Integer sitaHttpStatusCode, String redirtarget,
            String rawDocument, String robotsTxtContent, String originalHttpHeader,
            HttpResponse parsedHttpHeaders, Integer serverHttpStatusCode, boolean errorState,
            Long responseTime, @NotNull YandexCharset charset,
            @NotNull YandexDocumentLanguage language, @NotNull YandexMimeType mimeType)
    {
        super(allowedInRobotsTxt, ip4, sitaHttpStatusCode, redirtarget, rawDocument, robotsTxtContent, originalHttpHeader,
                parsedHttpHeaders, serverHttpStatusCode, errorState, responseTime, charset, language, mimeType);
    }

    public SitaUrlFetchExtendedResponse(SitaResponseError sitaResponseError) {
        super(null, null, null, null, null, null, null, null, null, true, null, YandexCharset.UNKNOWN,
                YandexDocumentLanguage.UNKNOWN, YandexMimeType.UNKNOWN);
        this.sitaResponseError = sitaResponseError;
    }

    public void setSitaResponseError(SitaResponseError sitaResponseError) {
        this.sitaResponseError = sitaResponseError;
    }

    public SitaResponseError getSitaResponseError() {
        return sitaResponseError;
    }

    public static enum SitaResponseError {
        NO_ERROR,
        EMPTY_RESULT,
        INCOMPLETE_RESPONSE,
        TIMEOUT_EXCEEDED,
    }
}
