package ru.yandex.wmtools.common.sita;

import java.io.IOException;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author aherman
 */
class SitaUrlFetchJsonRequest {
    private static final Logger log = LoggerFactory.getLogger(SitaUrlFetchJsonRequest.class);

    private static final ObjectMapper OM = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public static String toJson(SitaUrlFetchRequest sitaUrlFetchRequest, String sitaUser, String sitaProxyUserName) throws IOException {
        String json = OM.writeValueAsString(toRequest(sitaUrlFetchRequest, sitaUser, sitaProxyUserName));
        log.debug("Sita request: {}", json);
        return json;
    }

    static SitaJson.TRequest toRequest(SitaUrlFetchRequest sitaUrlFetchRequest, String sitaUser, String sitaProxyUserName) {
        SitaJson.TRequest request = new SitaJson.TRequest();

        request.AuthInfo = new SitaJson.TAuthInfo();
        request.AuthInfo.User = sitaProxyUserName;

        SitaJson.TActionData actionData = new SitaJson.TActionData();
        request.Data = new SitaJson.TActionData[]{actionData};
        actionData.Url = sitaUrlFetchRequest.getUri().toASCIIString();

        SitaJson.TAction action = new SitaJson.TAction();
        request.Actions = new SitaJson.TAction[]{action};

        action.UrlFetchingData = new SitaJson.TUrlFetchingData();
        action.UrlFetchingData.CheckIfAllowed = sitaUrlFetchRequest.getCheckAllowedInRobotsTxt();
        action.UrlFetchingData.DocumentFormat = sitaUrlFetchRequest.getDocumentFormat().name();
        action.UrlFetchingData.RobotsTxtFormat = sitaUrlFetchRequest.getRobotsTxtFormat().name();

        request.Settings = new SitaJson.TSettings();
        request.Settings.UrlValidator = SitaJson.EUrlValidator.ROBOT_URL_VALIDATOR;
        SitaJson.TZoraSettings zoraSettings = new SitaJson.TZoraSettings();
        request.Settings.OnlineZora = zoraSettings;
        zoraSettings.Freshness = sitaUrlFetchRequest.getFreshness();
        zoraSettings.Timeout = sitaUrlFetchRequest.getTimeout();
        if (sitaUrlFetchRequest.getIfModifiedSince() != null) {
            zoraSettings.IfModifiedSince = sitaUrlFetchRequest.getIfModifiedSince();
        }
        zoraSettings.UserAgent = sitaUrlFetchRequest.getUserAgent().getValue();
        zoraSettings.User = sitaUser;
        if (sitaUrlFetchRequest.getRequestTimeout() != SitaRequestTimeout.DEFAULT) {
            zoraSettings.DataSourceName = toDatasourceName(sitaUrlFetchRequest.getRequestTimeout());
        }

        return request;
    }

    private static SitaJson.WebmasterDatasourceName toDatasourceName(SitaRequestTimeout requestTimeout) {
        switch (requestTimeout) {
            case _15_SECONDS: return SitaJson.WebmasterDatasourceName.wm_onlinezora_15s;
            case _40_SECONDS: return SitaJson.WebmasterDatasourceName.wm_onlinezora_40s;
        }
        throw new IllegalArgumentException("Unsupported timeout: " + requestTimeout);
    }

}
