package ru.yandex.wmtools.common.sita;

import java.net.URI;

import org.jetbrains.annotations.NotNull;

/**
 * @author aherman
 */
public class SitaUrlFetchRequest {
    private final URI uri;
    private final DocumentFormatEnum documentFormat;
    private final RobotsTxtFormatEnum robotsTxtFormat;
    private final UserAgentEnum userAgent;
    private final boolean checkAllowedInRobotsTxt;
    private final Integer ifModifiedSince;
    private final Integer timeout;
    private final Integer freshness;
    private final SitaRequestTimeout requestTimeout;
    private String requestJson;

    private int sitaSocketTimeoutMillis;

    public SitaUrlFetchRequest(@NotNull URI uri, DocumentFormatEnum documentFormat,
            RobotsTxtFormatEnum robotsTxtFormat, UserAgentEnum userAgent, boolean checkAllowedInRobotsTxt,
            Integer ifModifiedSince, Integer timeout, Integer freshness, SitaRequestTimeout sitaRequestTimeout)
    {
        if (uri == null) {
            throw new NullPointerException("Url must not be null");
        }
        this.uri = uri;
        this.documentFormat = documentFormat;
        this.robotsTxtFormat = robotsTxtFormat;
        this.userAgent = userAgent;
        this.checkAllowedInRobotsTxt = checkAllowedInRobotsTxt;
        this.ifModifiedSince = ifModifiedSince;
        this.timeout = timeout;
        this.freshness = freshness;
        this.requestTimeout = sitaRequestTimeout;
    }

    public URI getUri() {
        return uri;
    }

    public DocumentFormatEnum getDocumentFormat() {
        return documentFormat;
    }

    public RobotsTxtFormatEnum getRobotsTxtFormat() {
        return robotsTxtFormat;
    }

    public UserAgentEnum getUserAgent() {
        return userAgent;
    }

    public boolean getCheckAllowedInRobotsTxt() {
        return checkAllowedInRobotsTxt;
    }

    public Integer getIfModifiedSince() {
        return ifModifiedSince;
    }

    public Integer getTimeout() {
        return timeout;
    }

    public Integer getFreshness() {
        return freshness;
    }

    public int getSitaSocketTimeoutMillis() {
        return sitaSocketTimeoutMillis;
    }

    public void setSitaSocketTimeoutMillis(int sitaSocketTimeoutMillis) {
        this.sitaSocketTimeoutMillis = sitaSocketTimeoutMillis;
    }

    public SitaRequestTimeout getRequestTimeout() {
        return requestTimeout;
    }

    public String getRequestJson() {
        return requestJson;
    }

    public void setRequestJson(String requestJson) {
        this.requestJson = requestJson;
    }

    SitaUrlFetchRequest withUrl(@NotNull URI uri) {
        SitaUrlFetchRequest sitaUrlFetchRequest = new SitaUrlFetchRequest(uri,
                this.documentFormat,
                this.robotsTxtFormat,
                this.userAgent,
                this.checkAllowedInRobotsTxt,
                this.ifModifiedSince,
                this.timeout,
                this.freshness,
                this.requestTimeout);
        sitaUrlFetchRequest.setSitaSocketTimeoutMillis(this.sitaSocketTimeoutMillis);
        return sitaUrlFetchRequest;
    }
}
