package ru.yandex.wmtools.common.sita;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.List;

/**
 * User: azakharov
 * Date: 28.02.14
 * Time: 18:39
 */
public class SitaUrlInfoReadingJsonRequest {

    private static final Logger log = LoggerFactory.getLogger(SitaUrlInfoReadingJsonRequest.class);

    private static final ObjectMapper OM = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public static String toJson(SitaUrlInfoReadingRequest sitaUrlInfoReadingRequest, String sitaProxyUserName) throws IOException {
        String json = OM.writeValueAsString(toRequest(sitaUrlInfoReadingRequest, sitaProxyUserName));
        log.debug("Sita request: {}", json);
        return json;
    }

    static SitaJson.TRequest toRequest(SitaUrlInfoReadingRequest sitaUrlInfoReadingRequest, String sitaProxyUserName) {
        SitaJson.TRequest request = new SitaJson.TRequest();

        request.AuthInfo = new SitaJson.TAuthInfo();
        request.AuthInfo.User = sitaProxyUserName;

        SitaJson.TActionData actionData = new SitaJson.TActionData();
        request.Data = new SitaJson.TActionData[]{actionData};
        actionData.Url = sitaUrlInfoReadingRequest.getUri().toASCIIString();

        SitaJson.TAction action = new SitaJson.TAction();
        request.Actions = new SitaJson.TAction[]{action};

        action.Type = SitaJson.EActionType.AT_URL_INFO_READING;
        action.UrlInfoReadingData = new SitaJson.TUrlInfoReadingData();

        final List<KiwiAttributeFilter> filters = sitaUrlInfoReadingRequest.getKiwiAttributeFilters();
        if (filters != null) {
            action.UrlInfoReadingData.KiwiAttributeFilters = new SitaJson.TKiwiAttributeFilter[filters.size()];

            int i = 0;
            for (KiwiAttributeFilter filter : filters) {
                action.UrlInfoReadingData.KiwiAttributeFilters[i] = new SitaJson.TKiwiAttributeFilter();

                action.UrlInfoReadingData.KiwiAttributeFilters[i].Name = filter.getAttributeName();
                if (filter.getTimestamp() != null) {
                    action.UrlInfoReadingData.KiwiAttributeFilters[i].Timestamp = filter.getTimestamp().getTime() / 1000L;
                }
                action.UrlInfoReadingData.KiwiAttributeFilters[i].Branch = filter.getBranch();

                i++;
            }
        }

        action.UrlInfoReadingData.KiwiQuery = sitaUrlInfoReadingRequest.getKiwiQuery();

        action.UrlInfoReadingData.DataType = sitaUrlInfoReadingRequest.getDataType().name();

        request.Settings = new SitaJson.TSettings();
        request.Settings.UrlValidator = SitaJson.EUrlValidator.ROBOT_URL_VALIDATOR;
        if (sitaUrlInfoReadingRequest.getMaxDataAge() != null) {
            request.Settings.MaxDataAge = sitaUrlInfoReadingRequest.getMaxDataAge();
        }
        if (sitaUrlInfoReadingRequest.getMergeReplicas() != null ||
                sitaUrlInfoReadingRequest.getUseDeltas() != null) {
            request.Settings.Kiwi = new SitaJson.TKiwiSettings();
            request.Settings.Kiwi.MergeReplicas = sitaUrlInfoReadingRequest.getMergeReplicas();
            request.Settings.Kiwi.UseDeltas = sitaUrlInfoReadingRequest.getUseDeltas();
        }

        return request;
    }
}
