package ru.yandex.wmtools.common.sita;

import java.net.URI;
import java.util.List;

/**
 * User: azakharov
 * Date: 28.02.14
 * Time: 18:32
 */
public class SitaUrlInfoReadingRequest {
    private final URI uri;

    private final List<KiwiAttributeFilter> kiwiAttributeFilters;
    private final String kiwiQuery;
    private final KiwiDataTypeEnum dataType;

    private final SitaRequestTimeout requestTimeout;

    private int sitaSocketTimeoutMillis;

    private Long maxDataAge = null;
    private Boolean mergeReplicas = null;
    private Long useDeltas = null;

    private SitaUrlInfoReadingRequest(URI uri, List<KiwiAttributeFilter> kiwiAttributeFilters, String kiwiQuery,
                                      KiwiDataTypeEnum dataType, SitaRequestTimeout requestTimeout) {
        this.uri = uri;
        this.kiwiAttributeFilters = kiwiAttributeFilters;
        this.kiwiQuery = kiwiQuery;
        this.dataType = dataType;
        this.requestTimeout = requestTimeout;
    }

    public SitaUrlInfoReadingRequest(URI uri,
                                     List<KiwiAttributeFilter> kiwiAttributeFilters,
                                     KiwiDataTypeEnum dataType,
                                     SitaRequestTimeout requestTimeout) {
        this(uri, kiwiAttributeFilters, null, dataType, requestTimeout);
    }

    public SitaUrlInfoReadingRequest(URI uri,
                                     String kiwiQuery,
                                     KiwiDataTypeEnum dataType,
                                     SitaRequestTimeout requestTimeout) {
        this(uri, null, kiwiQuery, dataType, requestTimeout);
    }

    public URI getUri() {
        return uri;
    }

    public List<KiwiAttributeFilter> getKiwiAttributeFilters() {
        return kiwiAttributeFilters;
    }

    public String getKiwiQuery() {
        return kiwiQuery;
    }

    public KiwiDataTypeEnum getDataType() {
        return dataType;
    }

    public SitaRequestTimeout getRequestTimeout() {
        return requestTimeout;
    }

    public int getSitaSocketTimeoutMillis() {
        return sitaSocketTimeoutMillis;
    }

    public void setSitaSocketTimeoutMillis(int sitaSocketTimeoutMillis) {
        this.sitaSocketTimeoutMillis = sitaSocketTimeoutMillis;
    }

    public Long getMaxDataAge() {
        return maxDataAge;
    }

    public void setMaxDataAge(Long maxDataAge) {
        this.maxDataAge = maxDataAge;
    }

    public Boolean getMergeReplicas() {
        return mergeReplicas;
    }

    public void setMergeReplicas(Boolean mergeReplicas) {
        this.mergeReplicas = mergeReplicas;
    }

    public Long getUseDeltas() {
        return useDeltas;
    }

    public void setUseDeltas(Long useDeltas) {
        this.useDeltas = useDeltas;
    }
}
