package ru.yandex.wmtools.common.sita;

/**
 * User: azakharov
 * Date: 30.04.15
 * Time: 13:54
 */
public class SitaUrlStatusCheckingJson {

    public static class TUrlStatusCheckingData {
        /** Search region (Russia, Turkey, Ukraine) */
        public ESearchRegion SearchRegion;
        /** If true, SEARCHABLE status will be checked via real search */
        public boolean UseRealSearch;
        /** If true, we will download documents, that haven't been downloaded yet */
        public boolean UseZora;
        /** If true, canonization step will be skipped. CanonizedUrl will be equal to Url from request. */
        public boolean SkipCanonization;
        /** If true, skips dbview quota checks. */
        public boolean NoDBViewQuota;
        /** If true, we will use data from oxygen to check url's status */
        public boolean UseOxygen;
        /** If true, we will add QUICK and QUICK_SAMOHOD to sss field in scraper request */
        public boolean UseQuickSearch;
        /** If true, dbview step will be skipped */
        public boolean SkipDBView;
        /** Max allowed depth of recursive status checks by redirections */
        public long MaxRecursiveStatusChecks;
        /** Search query to check if url is on serp */
        public String SearchQuery;
        /** Id of region query was made from */
        public int SearchQueryRequesterRegion;
    }

    public enum ESearchRegion {
        SR_RUS,
        SR_TUR,
        SR_UKR
    }

    public static class TUrlStatusCheckingResult {
        // Url from request
        public String Url;
        // Canonized version of Url
        public String CanonizedUrl;
        // Status of CanonizedUrl
        public EUrlStatus UrlStatus;
        // True, if CanonizedUrl's host is multilang
        public Boolean HostIsMultiLang;
        // Owner for the CanonizedUrl
        public String UrlOwner;
        // Robot time, that were used for this url's check
        public TRobotTimes UsedTimes;
        // Url, that is found on realsearch
        public String RealSearchUrl;
        // Status was set for this url
        public String StatusTargetUrl;
        // RedirTarget for Url from request
        public String RedirTargetUrl;
        // Canonized version of RedirTargetUrl
        public String CanonizedRedirTargetUrl;
        public String RobotMainContentUrl;
        public String SearchQuery;
        // Id of region query was made from
        public Integer SearchQueryRequesterRegion;

        public TWalrusDocInfo WalrusDocInfo;
        public TKiwiDocInfo KiWiDocInfo;
        public TZoraDocInfo ZoraDocInfo;
        public TUkropDocInfo UkropDocInfo;
        public TOxygenDocInfo OxygenDocInfo; // deprecated

        // Add status-specific extended statuses (with tags 100 and more)
        public TFilteredExtendedStatus FilteredExtendedStatus;
        public TSearchableExtendedStatus SearchableExtendedStatus;
        public TUrlAntispamCheckingResult SpamExtendedStatus;
        public TCrawledExtendedStatus CrawledExtendedStatus;
        public TNotDiscoveredExtendedStatus NotDiscoveredExtendedStatus;
        public TNotCrawlableExtendedStatus NotCrawlableExtendedStatus;
        public TNotIndexedExtendedStatus NotIndexedExtendedStatus;
        public TErrorExtendedStatus ErrorExtendedStatus;
        public TPostCrawlDeletedExtendedStatus PostCrawlDeletedExtendedStatus;
        public TDeadUrlExtendedStatus DeadUrlExtendedStatus;
        public TUnknownExtendedStatus UnknownExtendedStatus;
    }

    public enum EUrlStatus {
        BAD_URL,
        FILTERED,
        SPAM,
        SEARCHABLE,
        SEARCHABLE_BY_URL_QUERY,
        SEARCHABLE_BY_URL_NOT_QUERY,
        SEARCHABLE_BY_URL,
        SEARCHABLE_BY_ROBOT,
        CRAWLED,
        CRAWLED_VERY_FRESH,
        NOT_INDEXED,
        SR_DELETED,
        POST_CRAWL_DELETED,
        NOT_CRAWLED,
        NOT_CRAWLABLE,
        DEAD_URL,
        NOT_DISCOVERED,
        MIRROR_ERROR,

        ERROR,
        UNKNOWN,
    }

    public static class TRobotTimes {
        public Long BaseCreatedAt;
        public Long BaseSwitchedAt;
        public Long LatestBaseCreatedAt;
        public Long LatestBaseSwitchedAt;
    }

    public static class TWalrusDocInfo {
        public long HttpCode;
        public String WalrusName;
        public int Encoding;
        public String EncodingName;
        public long Language;
        public String LanguageName;
    }

    public static class TKiwiDocInfo {
        public Long HttpCode;
        public Long HttpCodeInBase; // deprecated

        public Integer  Encoding;
        public String EncodingName;

        public Long Language;
        public String LanguageName;

        public String HostStatus;

        // True, if HTML or HTTPResponse is not empty
        public Boolean HasDocument;
        public Long DocumentTimestamp;

        public Boolean ForbiddenByRobotsTxt;

        public Boolean HasAllowedSource;
        public TRobotSourceInfo[] Sources;

        public TStatusAttrInfo[] Statuses;
    }

    public static class TRobotSourceInfo {
        public Long SourceId;
        public Long Timestamp;
        public Boolean IsAllowed;
        public Boolean IsFirstTrustedAccess;
    }

    public static class TStatusAttrInfo {
        public enum EAttrLabel {
            LATEST,
            BEFORE_BASE_SWITCH
        }

        public Long Value;
        public Long Timestamp;
        public EAttrLabel Label;
        public String Description;
    }

    public static class TZoraDocInfo {
        public Long HttpCode;
        public Integer  Encoding;
        public String EncodingName;
        public Long Language;
        public String LanguageName;
    }

    public static class TUkropDocInfo {
        public Boolean HasKey;
        public Boolean FromValidSource;
        public Long FromValidSourceTimestamp;
        public Long LastAccess;
        public Long LastAccessTimestamp;
        public Long HttpCode;
        public Long HttpCodeTimestamp;
        public String RedirTarget;
        public Long RedirTargetTimestamp;
    }

    public static class TOxygenDocInfo {
        Boolean HasKey;
        String OxygenShardId;
    }

    public static class TFilteredExtendedStatus {
        // Reasons of filtering
        public EFilteredStatusReason[] Reasons;
        // Filter name
        public String FilterName;
    }

    public enum EFilteredStatusReason {
        FR_BANNED_BY_RFL,
        FR_BANNED_BY_FLT
    }

    public static class TShardInfoEntry {
        public String PrimusDescription;
        public String ShardName;
        public Long  DocumentShardIndex;
        public Long PrimusTimestamp;
    }

    public static class TSearchableExtendedStatus {
        // Shards, containing specific document
        public TShardInfoEntry[] ShardInfoEntries;

        public static class TRegionShardsInfo {
            public String Region;
            public TShardInfoEntry[] ShardInfoEntries;
        }

        public TRegionShardsInfo[] RegionShardInfoEntries;
    }

    public static class TCrawledExtendedStatus {
        public enum ECrawledStatusReason {
            CR_OTHER,
            CR_VERY_FRESH,               // deprecated
            CR_NOT_ENOUGH_RANK,
            CR_NO_RULE,
            CR_HAS_RULE_NOT_SEARCHABLE,
            CR_WAS_GOOD_BEFORE_YT,
            CR_WAS_BAD_BEFORE_YT,
            CR_HAD_NO_RULE_BEFORE_YT,
            CR_ONLY_IN_WALRUS,
            CR_SEARCHABLE_ONLY_IN_KIWI  // deprecated
        }

        // Reason, why we don't see crawled document on search
        public ECrawledStatusReason Reason;
    }

    public static class TPostCrawlDeletedExtendedStatus {
        public enum EPostCrawlDeletedStatusReason {
            PCDR_CRAWLED_BY_UKROP
        }

        public EPostCrawlDeletedStatusReason Reason;
    }

    public static class TNotDiscoveredExtendedStatus {
        public enum ENotDiscoveredStatusReason {
            NDR_UNKNOWN_HOST,
            NDR_NO_MULTILANG_VERSION,
            NDR_KNOWN_HOST_UNKNOWN_URL,
            NDR_ZORA_ERROR // deprecated
        }

        public ENotDiscoveredStatusReason Reason;
    }

    public static class TNotCrawlableExtendedStatus {
        public enum ENotCrawlableStatusReason {
            NCR_FORBIDDEN_BY_ROBOTS_TXT,
            NCR_FORBIDDEN_BY_NOINDEX,
            NCR_CONNECTION_ERROR,
            NCR_CRAWLER_ERROR,
            NCR_FILTERED,
            NCR_HTTP_ERROR,                // deprecated
            NCR_SPIDER_PROTOCOL_ERROR,
            NCR_DISALLOW_BY_UKROP,
            NCR_NOT_CRAWLABLE_HOST
        }

        public ENotCrawlableStatusReason Reason;
    }

    public static class TDeadUrlExtendedStatus {
        public enum EDeadUrlStatusReason {
            DUR_BY_UKROP,
            DUR_CYCLIC_REDIRECT,
            DUR_TOO_DEEP_REDIRECT,
            DUR_REDIRECT_WITHOUT_TARGET,
            DUR_REDIRECT_WITHOUT_TARGET_BY_UKROP,
            DUR_REDIRECT_OTHER,
            DUR_HTTP_ERROR,
            DUR_DEAD_HOST,
        }

        public EDeadUrlStatusReason Reason;
    }

    public static class TNotIndexedExtendedStatus {
        public enum ENotIndexedStatusReason {
            NIR_SEMIDUP_WITHOUT_MAIN_URL,
            NIR_SEMIDUP_WITH_MAIN_URL,
            NIR_CRAWLED_BY_UKROP,
            NIR_OTHER
        }

        public ENotIndexedStatusReason Reason;
    }

    public static class TErrorExtendedStatus {
        public enum EErrorStatusReason {
            EER_GEMINI,
            EER_KIWI,
            EER_KIWI_CALC,
            EER_DBVIEW_PARSE,
            EER_XML_SEARCH,
            EER_DBVIEW_CONNECT,
            EER_READ_BT,
            EER_READ_YT,
            EER_TOO_LONG_URL,
            EER_BANFILTER_HTTP,
            EER_BANFILTER_JSON,
            EER_BANFILTER_INVALID_URLS,
            EER_KIWI_DYNAMIC_ANTISPAM,
            EER_KIWI_STATIC_ANTISPAM,
            EER_SCRAPER_HTTP,
            EER_SCRAPER_PARSE,
            EER_UKROP,
            EER_URL_EXTENSION,
            EER_ZORA_MSGBUS,
            EER_ZORA_CONSTRAINT,
            EER_ZORA_NO_HTTPCODE,
            EER_NO_BT_FOR_YT,
            EER_SEARCH_BASE_TIMES_CHACHE,
            EER_SCRAPER_PROCESSING,
            EER_OXYGEN,                   // deprecated
            EER_DBVIEW_QUOTA_EXCEEDED
        }

        public EErrorStatusReason Reason;
    }

    public static class TUnknownExtendedStatus {
        public enum EUnknownStatusReason {
            EUR_INFINITE_REDIRECT_CANONIZATION_CYCLE,
            EUR_TOO_DEEP_REDIRECT_CANONIZATION_CYCLE,
            EUR_MAIN_CONTENT_URL_REDIRECT,
            EUR_UNKNOWN_HTTPCODE_IN_UKROP,
        }

        public EUnknownStatusReason Reason;
    }

    public enum EUrlAntispamStatus {
        NOT_SPAM,
        SPAM_STATIC,
        SPAM_DYNAMIC,
        SPAM_MIDDLE
    }

    public static class TStaticAntispamResult {
        public Boolean IsBanned;
    }

    public static class TDynamicAntispamResult {
        public Boolean IsBanned;
        public Long Timestamp;       // deprecated
        public String Reason;        // deprecated
    }

    public static class TMiddleAntispamResult {
        public Boolean IsBanned;
        public Long Timestamp;
    }

    public static class TUrlAntispamCheckingResult {
        // Overall status, based on results of all antispam checks
        public EUrlAntispamStatus AntispamStatus;

        public TStaticAntispamResult StaticAntispam;
        public TDynamicAntispamResult DynamicAntispam;
        public TMiddleAntispamResult MiddleAntispam;
    }
}
