package ru.yandex.wmtools.common.sita;

import ru.yandex.wmtools.common.util.enums.EnumResolver;

public enum UserAgentEnum {
    ROBOT(      "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"),
    MIRRORS(    "Mozilla/5.0 (compatible; YandexBot/3.0; MirrorDetector; +http://yandex.com/bots)"),
    IMAGES(     "Mozilla/5.0 (compatible; YandexImages/3.0; +http://yandex.com/bots)"),
    VIDEO(      "Mozilla/5.0 (compatible; YandexVideo/3.0; +http://yandex.com/bots)"),
    FAVICONS(   "Mozilla/5.0 (compatible; YandexFavicons/1.0; +http://yandex.com/bots)"),
    WEBMASTER(  "Mozilla/5.0 (compatible; YandexWebmaster/2.0; +http://yandex.com/bots)"),
    RESIZER(    "Mozilla/5.0 (compatible; YandexImageResizer/2.0; +http://yandex.com/bots)"),
    NEWS(       "Mozilla/5.0 (compatible; YandexNews/3.0; +http://yandex.com/bots)"),
    MEDIA(      "Mozilla/5.0 (compatible; YandexMedia/3.0; +http://yandex.com/bots)"),
    BLOGS(      "Mozilla/5.0 (compatible; YandexBlogs/0.99; robot; +http://yandex.com/bots)"),
    DIRECT(     "Mozilla/5.0 (compatible; YandexDirect/3.0; +http://yandex.com/bots)"),
    DYATEL(     "Mozilla/5.0 (compatible; YandexDirect/2.0; Dyatel; +http://yandex.com/bots)"),
    METRIKA(    "Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots)"),
    CATALOG(    "Mozilla/5.0 (compatible; YandexCatalog/3.0; +http://yandex.com/bots)"),
    ANTIVIRUS(  "Mozilla/5.0 (compatible; YandexAntivirus/2.0; +http://yandex.com/bots)"),
    ZAKLADKI(   "Mozilla/5.0 (compatible; YandexZakladki/3.0; Dyatel; +http://yandex.com/bots)");

    private String value;

    private UserAgentEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

//    public static UserAgentEnum getByName(String value) {
//        for (UserAgentEnum agent : values()) {
//            if (agent.name().equalsIgnoreCase(value)) {
//                return agent;
//            }
//        }
//
//        return null;
//    }

    public static UserAgentEnum getByValue(String value) {
        for (UserAgentEnum agent : values()) {
            if (agent.value.equalsIgnoreCase(value)) {
                return agent;
            }
        }

        return null;
    }

    public static final EnumResolver<UserAgentEnum> R = EnumResolver.er(UserAgentEnum.class);
}
