package ru.yandex.wmtools.common.sita;

import ru.yandex.wmtools.common.util.enums.IntEnum;
import ru.yandex.wmtools.common.util.enums.IntEnumResolver;

/**
 * Yandex charsets from util/charset/doccodes.h
 *
 * @author aherman
 */
public enum YandexCharset implements IntEnum {
    UNKNOWN             (-100, null),

    CODES_UNSUPPORTED   (-2, null),             // valid but unsupported encoding
    CODES_UNKNOWN       (-1, null),             // invalid or unspecified encoding
    CODES_WIN           (0, "windows-1251"),    // [ 0] WINDOWS_1251     Windows
    CODES_KOI8          (1, "KOI8-U"),          // [ 1] KOI8_U           Koi8-u
    CODES_ALT           (2, "IBM866"),          // [ 2] IBM_866          MS DOS, alternative
    CODES_MAC           (3, "x-MacCyrillic"),   // [ 3] MAC_CYRILLIC     Macintosh
    CODES_MAIN          (4, "ISO-8859-5"),      // [ 4] ISO_LATIN_CYRILLIC Main
    CODES_ASCII         (5, "windows-1252"),    // [ 5] WINDOWS_1252     Latin 1
    CODES_RESERVED_3    (6, null),              // reserved code: use it for new encodings before adding them to the end of the list
    CODES_WIN_EAST      (7, "windows-1250"),    // [ 7] WINDOWS_1250     WIN PL
    CODES_ISO_EAST      (8, "ISO-8859-2"),      // [ 8] ISO_8859_2       ISO PL

    // our superset of subset of windows-1251
    CODES_YANDEX        (9, "windows-1251"),    // [ 9] YANDEX
    CODES_UTF_16BE      (10, "UTF-16BE"),       // [10] UTF_16BE
    CODES_UTF_16LE      (11, "UTF-16LE"),       // [11] UTF_16LE

    // missing standard codepages
    CODES_IBM855        (12, "IBM855"),         // [12] IBM_855
    CODES_UTF8          (13, "UTF-8"),          // [13] UTF8
    CODES_UNKNOWNPLANE  (14, null),             // [14] Unrecognized characters are mapped into the PUA: U+F000..U+F0FF

    CODES_KAZWIN        (15, "windows-1251"),   // [15] WINDOWS_1251_K   Kazakh version of Windows-1251
    CODES_TATWIN        (16, "windows-1251"),   // [16] WINDOWS_1251_T   Tatarian version of Windows-1251
    CODES_ARMSCII       (17, "US-ASCII"),       // [17] Armenian ASCII
    CODES_GEO_ITA       (18, null),             // [18] Academy of Sciences Georgian
    CODES_GEO_PS        (19, null),             // [19] Georgian Parliament
    CODES_ISO_8859_3    (20, "ISO-8859-3"),     // [20] Latin-3: Turkish, Maltese and Esperanto
    CODES_ISO_8859_4    (21, "ISO-8859-4"),     // [21] Latin-4: Estonian, Latvian, Lithuanian, Greenlandic, Sami
    CODES_ISO_8859_6    (22, "ISO-8859-6"),     // [22] Latin/Arabic: Arabic
    CODES_ISO_8859_7    (23, "ISO-8859-7"),     // [23] Latin/Greek: Greek
    CODES_ISO_8859_8    (24, "ISO-8859-8"),     // [24] Latin/Hebrew: Hebrew
    CODES_ISO_8859_9    (25, "ISO-8859-9"),     // [25] Latin-5 or Turkish: Turkish
    CODES_ISO_8859_13   (26, "ISO-8859-13"),    // [26] Latin-7 or Baltic Rim: Baltic languages
    CODES_ISO_8859_15   (27, "ISO-8859-15"),    // [27] Latin-9: Western European languages
    CODES_ISO_8859_16   (28, "ISO-8859-16"),    // [28] Latin-10: South-Eastern European languages
    CODES_WINDOWS_1253  (29, "windows-1253"),   // [29] for Greek
    CODES_WINDOWS_1254  (30, "windows-1254"),   // [30] for Turkish
    CODES_WINDOWS_1255  (31, "windows-1255"),   // [31] for Hebrew
    CODES_WINDOWS_1256  (32, "windows-1256"),   // [32] for Arabic
    CODES_WINDOWS_1257  (33, "windows-1257"),   // [33] for Estonian, Latvian and Lithuanian

    // these codes are all the other 8bit codes known by libiconv
    // they follow in alphanumeric order
    CODES_CP1046        (34, "x-IBM1046"),
    CODES_CP1124        (35, "x-IBM1124"),
    CODES_CP1125        (36, null),
    CODES_CP1129        (37, null),
    CODES_CP1131        (38, null),
    CODES_CP1133        (39, null),
    CODES_CP1161        (40, null),             // [40]
    CODES_CP1162        (41, null),
    CODES_CP1163        (42, null),
    CODES_CP1258        (43, "windows-1258"),
    CODES_CP437         (44, "IBM437"),
    CODES_CP737         (45, "x-IBM737"),
    CODES_CP775         (46, "IBM775"),
    CODES_CP850         (47, "IBM850"),
    CODES_CP852         (48, "IBM852"),
    CODES_CP853         (49, null),
    CODES_CP856         (50, "x-IBM856"),       // [50]
    CODES_CP857         (51, "IBM857"),
    CODES_CP858         (52, "IBM00858"),
    CODES_CP860         (53, "IBM860"),
    CODES_CP861         (54, "IBM861"),
    CODES_CP862         (55, "IBM862"),
    CODES_CP863         (56, "IBM863"),
    CODES_CP864         (57, "IBM864"),
    CODES_CP865         (58, "IBM865"),
    CODES_CP869         (59, "IBM869"),
    CODES_CP874         (60, "x-IBM874"),       // [60]
    CODES_CP922         (61, "x-IBM922"),
    CODES_HP_ROMAN8     (62, "hp-roman8"),
    CODES_ISO646_CN     (63, null),
    CODES_ISO646_JP     (64, null),
    CODES_ISO8859_10    (65, "ISO-8859-10"),
    CODES_ISO8859_11    (66, "ISO-8859-11"),
    CODES_ISO8859_14    (67, "ISO-8859-14"),
    CODES_JISX0201      (68, "JIS_X0201"),
    CODES_KOI8_T        (69, null),
    CODES_MAC_ARABIC    (70, "x-MacArabic"),    // [70]
    CODES_MAC_CENTRALEUROPE(71, "x-MacCentralEurope"),
    CODES_MAC_CROATIAN  (72, "x-MacCroatian"),
    CODES_MAC_GREEK     (73, "x-MacGreek"),
    CODES_MAC_HEBREW    (74, "x-MacHebrew"),
    CODES_MAC_ICELAND   (75, "x-MacIceland"),
    CODES_MAC_ROMANIA   (76, "x-MacRomania"),
    CODES_MAC_ROMAN     (77, "x-MacRoman"),
    CODES_MAC_THAI      (78, "x-MacThai"),
    CODES_MAC_TURKISH   (79, "x-MacTurkish"),
    CODES_RESERVED_2    (80, null),             // [80] reserved code: use it for new encodings before adding them to the end of the list
    CODES_MULELAO       (81, null),
    CODES_NEXTSTEP      (82, null),
    CODES_PT154         (83, null),
    CODES_RISCOS_LATIN1 (84, null),
    CODES_RK1048        (85, null),
    CODES_TCVN          (86, null),
    CODES_TDS565        (87, null),
    CODES_TIS620        (88, "TIS-620"),
    CODES_VISCII        (89, null),

    // libiconv multibyte codepages
    CODES_BIG5          (90, "Big5"),           // [90]
    CODES_BIG5_HKSCS    (91, "Big5-HKSCS"),
    CODES_BIG5_HKSCS_1999(92, null),
    CODES_BIG5_HKSCS_2001(93, "x-Big5-HKSCS-2001"),
    CODES_CP932         (94, "windows-31j"),
    CODES_CP936         (95, "GBK"),
    CODES_CP949         (96, "x-IBM949"),
    CODES_CP950         (97, "x-IBM950"),
    CODES_EUC_CN        (98, "GB2312"),
    CODES_EUC_JP        (99, "EUC-JP"),
    CODES_EUC_KR        (100, "EUC-KR"),  // [100]
    CODES_EUC_TW        (101, "x-EUC-TW"),
    CODES_GB18030       (102, "GB18030"),
    CODES_GBK           (103, "GBK"),
    CODES_HZ            (104, null),
    CODES_ISO_2022_CN   (105, "ISO-2022-CN"),
    CODES_ISO_2022_CN_EXT(106, null),
    CODES_ISO_2022_JP   (107, "ISO-2022-JP"),
    CODES_ISO_2022_JP_1 (108, null),
    CODES_ISO_2022_JP_2 (109, "ISO-2022-JP-2"),
    CODES_ISO_2022_KR   (110, "ISO-2022-KR"),  // [110]
    CODES_JOHAB         (111, "x-Johab"),
    CODES_SHIFT_JIS     (112, "Shift_JIS"),
    ;

    private final int value;
    private final String charsetName;

    private YandexCharset(int value, String charsetName) {
        this.value = value;
        this.charsetName = charsetName;
    }

    @Override
    public int value() {
        return value;
    }

    public String getCharsetName() {
        return charsetName;
    }

    public static final IntEnumResolver<YandexCharset> R = IntEnumResolver.r(YandexCharset.class);
}
