package ru.yandex.wmtools.common.sita;

import ru.yandex.wmtools.common.util.enums.IntEnum;
import ru.yandex.wmtools.common.util.enums.IntEnumResolver;

/**
 * Yandex document languages from util/charset/doccodes.h
 *
 * @author aherman
 */
public enum YandexDocumentLanguage implements IntEnum {
    UNKNOWN         (-1),

    LANG_UNK        (0), // Unknown
    LANG_RUS        (1), // Russian
    LANG_ENG        (2), // English
    LANG_POL        (3), // Polish
    LANG_HUN        (4), // Hungarian
    LANG_UKR        (5), // Ukrainian
    LANG_GER        (6), // German
    LANG_FRN        (7), // French
    LANG_TAT        (8), // Tatar
    LANG_BLR        (9), // Belorussian
    LANG_KAZ        (10), // Kazakh
    LANG_ALB        (11), // Albanian
    LANG_SPA        (12), // Spanish
    LANG_ITA        (13), // Italian
    LANG_ARM        (14), // Armenian
    LANG_DAN        (15), // Danish
    LANG_POR        (16), // Portuguese
    LANG_UNSET_17   (17), // missed language: use it for new languages before adding them to the end of the list
    LANG_SLO        (18), // Slovak
    LANG_SLV        (19), // Slovene
    LANG_DUT        (20), // Dutch (Netherlandish language)
    LANG_BUL        (21), // Bulgarian
    LANG_CAT        (22), // Catalan
    LANG_HRV        (23), // Croatian
    LANG_CZE        (24), // Czech
    LANG_GRE        (25), // Greek
    LANG_HEB        (26), // Hebrew
    LANG_NOR        (27), // Norwegian
    LANG_MAC        (28), // Macedonian
    LANG_SWE        (29), // Swedish
    LANG_KOR        (30), // Korean
    LANG_LAT        (31), // Latin
    LANG_BASIC_RUS  (32), // Simplified version of Russian (used at lemmer only)
    LANG_UNSET_33   (33), // missed language: use it for new languages before adding them to the end of the list
    LANG_UNSET_34   (34), // missed language: use it for new languages before adding them to the end of the list
    LANG_EMPTY      (35), // Indicate what document is empty
    LANG_UNK_LAT    (36), // Any unrecognized latin language
    LANG_UNK_CYR    (37), // Any unrecognized cyrillic language
    LANG_UNK_ALPHA  (38), // Any unrecognized alphabetic language not fit into previous categories
    LANG_FIN        (39), // Finnish
    LANG_EST        (40), // Estonian
    LANG_LAV        (41), // Latvian
    LANG_LIT        (42), // Lithuanian
    LANG_BAK        (43), // Bashkir
    LANG_TUR        (44), // Turkish
    LANG_RUM        (45), // Romanian (also Moldavian)
    LANG_MON        (46), // Mongolian
    LANG_UZB        (47), // Uzbek
    LANG_KIR        (48), // Kirghiz
    LANG_TGK        (49), // Tajik
    LANG_TUK        (50), // Turkmen
    LANG_SRP        (51), // Serbian
    LANG_AZE        (52), // Azerbaijani
    LANG_BASIC_ENG  (53), // Simplified version of English (used at lemmer only)
    LANG_GEO        (54), // Georgian
    LANG_ARA        (55), // Arabic
    LANG_PER        (56), // Persian
    LANG_CHU        (57), // Church Slavonic
    LANG_CHI        (58), // Chinese
    LANG_JPN        (59), // Japanese
    ;

    private final int value;

    private YandexDocumentLanguage(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<YandexDocumentLanguage> R = IntEnumResolver.r(YandexDocumentLanguage.class);
}
