package ru.yandex.wmtools.common.sita;

import ru.yandex.wmtools.common.util.enums.IntEnum;
import ru.yandex.wmtools.common.util.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum YandexMimeType implements IntEnum {
    UNKNOWN         (-1),

    MIME_UNKNOWN    (0),
    MIME_TEXT       (1),
    MIME_HTML       (2),  // MIME_XHTMLXML = MIME_HTML,
    MIME_PDF        (3),
    MIME_RTF        (4),
    MIME_DOC        (5),  // MIME_MSWORD = MIME_DOC,
    MIME_MPEG       (6),
    MIME_XML        (7),  // MIME_RSS =;MIME_XML,
    MIME_WML        (8),
    MIME_SWF        (9),  // MIME_FLASH = MIME_SWF,
    MIME_XLS        (10), // MIME_EXCEL = MIME_XLS,
    MIME_PPT        (11),
    MIME_IMAGE_JPG  (12),
    MIME_IMAGE_PJPG (13),
    MIME_IMAGE_PNG  (14),
    MIME_IMAGE_GIF  (15),
    MIME_DOCX       (16),
    MIME_ODT        (17),
    MIME_ODP        (18),
    MIME_ODS        (19),
    //MIME_XHTMLXML (20),
    MIME_IMAGE_BMP  (21),
    MIME_WAV        (22),
    MIME_ARCHIVE    (23),
    MIME_EXE        (24),
    MIME_ODG        (25),
    MIME_GZIP       (26),
    MIME_XLSX       (27),
    MIME_PPTX       (28),
    MIME_JAVASCRIPT (29),
    MIME_EPUB       (30),
    MIME_TEX        (31),
    ;

    private final int value;

    private YandexMimeType(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<YandexMimeType> R = IntEnumResolver.r(YandexMimeType.class);
}
