package ru.yandex.wmtools.common.sita.newmirroring;

import ru.yandex.wmtools.common.sita.SitaJson;

import java.net.URI;
import java.util.List;

/**
 * @author avhaliullin
 */
public class SitaNewMirroringRequest {
    private final URI url;
    private final List<URI> hosts;
    private final SitaJson.ENewMirroringAction action;

    private SitaNewMirroringRequest(URI url, List<URI> hosts, SitaJson.ENewMirroringAction action) {
        this.url = url;
        this.hosts = hosts;
        this.action = action;
    }

    public URI getUrl() {
        return url;
    }

    public List<URI> getHosts() {
        return hosts;
    }

    public SitaJson.ENewMirroringAction getAction() {
        return action;
    }

    public static SitaNewMirroringRequest createUnstick(URI host) {
        return new SitaNewMirroringRequest(host, null, SitaJson.ENewMirroringAction.UNSTICK);
    }

    public static SitaNewMirroringRequest createMove(URI newMain, List<URI> mirrors) {
        return new SitaNewMirroringRequest(newMain, mirrors, SitaJson.ENewMirroringAction.MOVE);
    }
}
