package ru.yandex.wmtools.common.sita.newmirroring;

import java.util.List;

/**
 * @author avhaliullin
 */
public class SitaNewMirroringResponse {
    private final SitaNewMirroringActionStatus status;
    private final List<Result> results;

    public SitaNewMirroringResponse(SitaNewMirroringActionStatus status, List<Result> results) {
        this.status = status;
        this.results = results;
    }

    public SitaNewMirroringActionStatus getStatus() {
        return status;
    }

    public List<Result> getResults() {
        return results;
    }

    public static class Result {
        private final String host;
        private final Integer httpCode;
        private final SitaNewMirroringHostStatus status;

        public Result(String host, Integer httpCode, SitaNewMirroringHostStatus status) {
            this.host = host;
            this.httpCode = httpCode;
            this.status = status;
        }

        public String getHost() {
            return host;
        }

        public Integer getHttpCode() {
            return httpCode;
        }

        public SitaNewMirroringHostStatus getStatus() {
            return status;
        }
    }
}
