package ru.yandex.wmtools.common.sita.url.status.checking;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.wmtools.common.sita.SitaJson;
import ru.yandex.wmtools.common.sita.SitaUrlStatusCheckingJson;

import java.io.IOException;

/**
 * User: azakharov
 * Date: 30.04.15
 * Time: 14:30
 */
public class SitaUrlStatusCheckingJsonRequest {
    private static final Logger log = LoggerFactory.getLogger(SitaUrlStatusCheckingJsonRequest.class);

    private static final ObjectMapper OM = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public static String toJson(SitaUrlStatusCheckingRequest request, String sitaProxyUserName) throws IOException {
        String json = OM.writeValueAsString(toRequest(request, sitaProxyUserName));
        log.debug("Sita request: {}", json);
        return json;
    }

    private static SitaJson.TRequest toRequest(SitaUrlStatusCheckingRequest sitaUrlInfoReadingRequest, String sitaProxyUserName) {
        SitaJson.TRequest request = new SitaJson.TRequest();

        request.AuthInfo = new SitaJson.TAuthInfo();
        request.AuthInfo.User = sitaProxyUserName;

        SitaJson.TActionData actionData = new SitaJson.TActionData();
        request.Data = new SitaJson.TActionData[]{actionData};
        actionData.Url = sitaUrlInfoReadingRequest.getUri().toASCIIString();

        SitaJson.TAction action = new SitaJson.TAction();
        request.Actions = new SitaJson.TAction[]{action};

        action.Type = SitaJson.EActionType.AT_URL_STATUS_CHECKING;
        action.UrlStatusCheckingData = new SitaUrlStatusCheckingJson.TUrlStatusCheckingData();
        action.UrlStatusCheckingData.SkipDBView = sitaUrlInfoReadingRequest.isSkipDbView();

        request.Settings = new SitaJson.TSettings();
        request.Settings.UrlValidator = SitaJson.EUrlValidator.ROBOT_URL_VALIDATOR;

        return request;
    }
}
