package ru.yandex.wmtools.common.sita.url.status.checking;

import org.jetbrains.annotations.NotNull;

import java.net.URI;

/**
 * User: azakharov
 * Date: 30.04.15
 * Time: 14:29
 */
public class SitaUrlStatusCheckingRequest {
    private final URI uri;
    private final boolean skipDbView;

    public SitaUrlStatusCheckingRequest(@NotNull URI uri, boolean skipDbView) {
        this.uri = uri;
        this.skipDbView = skipDbView;
    }

    public URI getUri() {
        return uri;
    }

    /**
     * Disables request to dbview (e.g. requests to htarc).
     * @return  true if requests to htarcs are disabled, otherwise false
     */
    public boolean isSkipDbView() {
        return skipDbView;
    }
}
