package ru.yandex.wmtools.common.sita.url.status.checking;

import java.util.List;

/**
 * User: azakharov
 * Date: 30.04.15
 * Time: 14:29
 */
public class SitaUrlStatusCheckingResponse {

    private final SitaUrlCheckingUrlStatusEnum status;
    private final List<SitaUrlCheckingExtendedStatusEnum> extendedStatuses;
    private final String canonizedUrl;
    private final Boolean multiLang;
    private final String urlOwner;
    private final String redirTargetUrl;
    private final String canonizedRedirTargetUrl;
    private final String robotMainContentUrl;

    public SitaUrlStatusCheckingResponse(SitaUrlCheckingUrlStatusEnum status, List<SitaUrlCheckingExtendedStatusEnum> extendedStatuses,
                                         String canonizedUrl, Boolean multiLang, String urlOwner,
                                         String redirTargetUrl, String canonizedRedirTargetUrl,
                                         String robotMainContentUrl) {
        this.status = status;
        this.extendedStatuses = extendedStatuses;
        this.canonizedUrl = canonizedUrl;
        this.multiLang = multiLang;
        this.urlOwner = urlOwner;
        this.redirTargetUrl = redirTargetUrl;
        this.canonizedRedirTargetUrl = canonizedRedirTargetUrl;
        this.robotMainContentUrl = robotMainContentUrl;
    }

    public SitaUrlCheckingUrlStatusEnum getStatus() {
        return status;
    }

    public List<SitaUrlCheckingExtendedStatusEnum> getExtendedStatuses() {
        return extendedStatuses;
    }

    public String getCanonizedUrl() {
        return canonizedUrl;
    }

    public Boolean getMultiLang() {
        return multiLang;
    }

    public String getUrlOwner() {
        return urlOwner;
    }

    public String getRedirTargetUrl() {
        return redirTargetUrl;
    }

    public String getCanonizedRedirTargetUrl() {
        return canonizedRedirTargetUrl;
    }

    public String getRobotMainContentUrl() {
        return robotMainContentUrl;
    }
}
