package ru.yandex.wmtools.common.sita.urlextension;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.wmtools.common.sita.SitaJson;

import java.io.IOException;

/**
 * @author avhaliullin
 */
public class SitaUrlExtensionJsonRequest {
    private static final Logger log = LoggerFactory.getLogger(SitaUrlExtensionJsonRequest.class);

    private static final ObjectMapper OM = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public static String toJson(SitaUrlExtensionRequest request, String sitaProxyUserName) throws IOException {
        String json = OM.writeValueAsString(toRequest(request, sitaProxyUserName));
        log.debug("Sita request: {}", json);
        return json;
    }

    private static SitaJson.TRequest toRequest(SitaUrlExtensionRequest sitaUrlExtensionRequest, String sitaProxyUserName) {
        SitaJson.TRequest request = new SitaJson.TRequest();

        request.AuthInfo = new SitaJson.TAuthInfo();
        request.AuthInfo.User = sitaProxyUserName;

        SitaJson.TActionData actionData = new SitaJson.TActionData();
        request.Data = new SitaJson.TActionData[]{actionData};
        actionData.Url = sitaUrlExtensionRequest.getUri().toASCIIString();

        SitaJson.TAction action = new SitaJson.TAction();
        request.Actions = new SitaJson.TAction[]{action};

        action.Type = SitaJson.EActionType.AT_URL_EXTENSION;


        return request;
    }
}
