package ru.yandex.wmtools.common.sita.urlextension;

import ru.yandex.wmtools.common.util.http.YandexHttpStatus;

import java.net.URI;
import java.util.List;

/**
 * @author avhaliullin
 */
public class UrlExtensionChain {
    private final List<Link> chain;

    public UrlExtensionChain(List<Link> chain) {
        this.chain = chain;
    }

    public List<Link> getChain() {
        return chain;
    }

    public Link getLastLink() {
        if (!chain.isEmpty()) {
            return chain.get(chain.size() - 1);
        } else {
            return null;
        }
    }

    public YandexHttpStatus getLastStatus() {
        Link lastLink = getLastLink();
        if (lastLink == null) {
            return null;
        } else {
            return lastLink.status;
        }
    }

    public boolean hasRedirects() {
        return chain.size() > 1;
    }

    public static class Link {
        private final String uri;
        private final YandexHttpStatus status;

        public Link(String uri, YandexHttpStatus status) {
            this.uri = uri;
            this.status = status;
        }

        public String getUri() {
            return uri;
        }

        public YandexHttpStatus getStatus() {
            return status;
        }
    }
}
