package ru.yandex.wmtools.common.util;

import ru.yandex.common.util.xml.XmlConvertable;
import ru.yandex.wmtools.common.data.info.WMUserInfo;
import ru.yandex.wmtools.common.data.wrappers.UserInfoWrapper;

public class AuthorizationInfoWrapper extends XmlDataWrapper<XmlConvertable> {
    private final WMUserInfo realUser;

    private final WMUserInfo virtualUser;

    public AuthorizationInfoWrapper(WMUserInfo realUser, WMUserInfo virtualUser) {
        super(null, "authorization-info");
        this.realUser = realUser;
        this.virtualUser = virtualUser;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        result.append("<real-user>");
        new UserInfoWrapper(realUser).toXml(result);
        result.append("</real-user>");
        result.append("<virtual-user>");
        new UserInfoWrapper(virtualUser).toXml(result);
        result.append("</virtual-user>");
    }
}
