package ru.yandex.wmtools.common.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;

/**
 * @author avhaliullin
 */
public class HistoryRedirectStrategy extends DefaultRedirectStrategy {
    private final List<URI> redirects = new ArrayList<URI>();

    @Override
    public boolean isRedirected(HttpRequest request,
                                org.apache.http.HttpResponse response,
                                HttpContext context) throws org.apache.http.ProtocolException {
        if (super.isRedirected(request, response, context)) {
            HttpUriRequest redirect = getRedirect(request, response, context);
            synchronized (redirects) {
                redirects.add(redirect.getURI());
            }
            return true;
        }
        return false;
    }

    @Override
    public org.apache.http.client.methods.HttpUriRequest getRedirect(org.apache.http.HttpRequest request, org.apache.http.HttpResponse response, org.apache.http.protocol.HttpContext context) throws org.apache.http.ProtocolException {
        return super.getRedirect(request, response, context);
    }


    public List<URI> getRedirects() {
        return redirects;
    }
}
