package ru.yandex.wmtools.common.util;

import java.io.InputStream;
import java.util.Collection;
import java.util.Map;

import org.jetbrains.annotations.Nullable;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class HttpResponse {
    private int statusCode;
    private long requestTime;
    private InputStream content;
    private long contentLength;
    private String contentEncoding;
    private String contentType;
    private Map<String, Collection<String>> headers;

    public HttpResponse(int statusCode, long requestTime, InputStream content, long contentLength,
                        String contentEncoding, String contentType, Map<String, Collection<String>> headers) {
        this.statusCode = statusCode;
        this.requestTime = requestTime;
        this.content = content;
        this.contentLength = contentLength;
        this.contentEncoding = contentEncoding;
        this.contentType = contentType;
        this.headers = headers;
    }

    public int getStatusCode() {
        return statusCode;
    }

    public long getRequestTime() {
        return requestTime;
    }

    @Nullable
    public InputStream getContent() {
        return content;
    }

    public long getContentLength() {
        return contentLength;
    }

    public String getContentEncoding() {
        return contentEncoding;
    }

    public String getContentType() {
        return contentType;
    }

    public Map<String, Collection<String>> getHeaders() {
        return headers;
    }
}
