package ru.yandex.wmtools.common.util;

import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.common.util.db.OrderByClause;
import ru.yandex.wmtools.common.error.InternalException;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;

/**
 * User: baton
 * Date: 18.10.2007
 * Time: 21:14:14
 */
public interface IServiceJdbcTemplate {
    JdbcOperations getJdbcOperations() throws InternalException;

    int queryForInt(final String sqlString, final Object... requestParams) throws InternalException;

    long queryForLong(final String sqlString, final Object... requestParams) throws InternalException;

    <T> T queryForObject(final String sqlString, final Class<T> aClass, final Object... requestParams) throws InternalException;

    <T> T queryForObject(final String sqlString, final ParameterizedRowMapper<T> parameterizedRowMapper, final Object... requestParams) throws InternalException;

    <T> List<T> query(final String sqlString, final ParameterizedRowMapper<T> parameterizedRowMapper, final Object... requestParams) throws InternalException;

    Map<String, Object> queryForMap(final String sqlString, final Object... requestParams) throws InternalException;

    List<Map<String, Object>> queryForList(final String sqlString, final Object... requestParams) throws InternalException;

    int update(final String sqlString, final Object... requestParams) throws InternalException;

    /**
     * Use this method for inserting single record into table, when you need to fetch generated by MySQL key
     *
     * @param sqlString
     * @param requestParams
     * @return Number, representing generated key or null, if nothing was inserted
     * @throws InternalException
     */
    Number insertSingle(String sqlString, Object... requestParams) throws InternalException;

    Date safeQueryForTimestamp(final String sqlString, final Object... requestParams) throws InternalException;

    Integer safeQueryForInt(final String sqlString, final Object... requestParams) throws InternalException;

    Long safeQueryForLong(final String sqlString, final Object... requestParams) throws InternalException;

    String safeQueryForString(final String sqlString, final Object... requestParams) throws InternalException;

    <E> E safeQueryForObject(final String sqlString, final ParameterizedRowMapper<E> parameterizedRowMapper, final Object... requestParams) throws InternalException;

    <K, V> NavigableMap<K, V> queryForNavigableMap(final String sqlString, final ParameterizedMapRowMapper<K, V> parameterizedRowMapper, final Object... requestParams) throws InternalException;

    void query(final String sqlString, final RowCallbackHandler rch, final Object... requestParams) throws InternalException;

    /**
     * Performs database select, for which you can specify 'limit' and 'order by', using special objects of
     * <code>OrderByClause</code> and <code>Pager</code> type.
     *
     * @param countSql  Database query, returning the number of rows that will be returned during <code>selectSql</code>
     *                  query.
     * @param selectSql Database query, returning rows, that will be mapped into Java objects using <code>mapper</code>.
     *                  This statement must have two placeholders: '%1$s' for ORDER BY statement and '%2$s' for LIMIT
     *                  statement, even if <code>order</code> and/or <code>pager</code> is null. If one or two of these
     *                  objects are <code>null</code>, corresponding placeholders will be replaced by empty strings.
     * @param mapper    Java class, that incapsulates logic of mapping database rows into Java objects.
     * @param order     Object, that stores information about ORDER BY statement creation.
     * @param pager     Object, that stores information about LIMIT statement creation.
     * @param params    Parameters of database query. Used to replace '?' marks in <code>countSql</code> and
     *                  <code>selectSql</code>. It means, that this two strings must have the same number of '?' marks
     *                  with equal meanings of the corresponding question marks.
     * @return Returns list of Java objects, mapped from rows, returned by the database query
     *         <code>selectSql</code>.
     * @throws InternalException Thrown if something's wrong.
     */
    <T> List<T> select(final String countSql, final String selectSql, final ParameterizedRowMapper<T> mapper, final OrderByClause order, final Pager pager, final Object... params) throws InternalException;

    /**
     * Performs database select, for which you can specify 'limit', using special object of <code>Pager</code> class.
     *
     * @param countSql  Database query, returning the number of rows that will be returned during <code>selectSql</code>
     *                  query.
     * @param selectSql Database query, returning rows, that will be mapped into Java objects using <code>mapper</code>.
     *                  This statement must have one placeholder: '%1$s' for LIMIT statement, even if <code>pager</code>
     *                  is null. If so, a placeholder will be replaced by an empty string.
     * @param mapper    Java class, that incapsulates logic of mapping database rows into Java objects.
     * @param pager     Object, that stores information about LIMIT statement creation.
     * @param params    Parameters of database query. Used to replace '?' marks in <code>countSql</code> and
     *                  <code>selectSql</code>. It means, that this two strings must have the same number of '?' marks
     *                  with equal meanings of the corresponding question marks.
     * @return Returns list of Java objects, mapped from rows, returned by the database query
     *         <code>selectSql</code>.
     * @throws InternalException Thrown if something's wrong.
     */
    <T> List<T> pageableSelect(final String countSql, final String selectSql, final ParameterizedRowMapper<T> mapper, final Pager pager, final Object... params) throws InternalException;

    /**
     * Performs database select, for which you can specify 'order by', using special object of <code>OrderByClause</code> class.
     *
     * @param selectSql Database query, returning rows, that will be mapped into Java objects using <code>mapper</code>.
     *                  This statement must have one placeholder: '%1$s' for ORDER BY statement, even if
     *                  <code>order</code> is null. If so, a placeholder will be replaced by an empty string.
     * @param mapper    Java class, that incapsulates logic of mapping database rows into Java objects.
     * @param order     Object, that stores information about ORDER BY statement creation.
     * @param params    Parameters of database query. Used to replace '?' marks in <code>selectSql</code>.
     * @return Returns list of Java objects, mapped from rows, returned by the database query
     *         <code>selectSql</code>.
     * @throws InternalException Thrown if something's wrong.
     */
    <T> List<T> orderableSelect(final String selectSql, final ParameterizedRowMapper<T> mapper, final OrderByClause order, final Object... params) throws InternalException;
}
