package ru.yandex.wmtools.common.util;

import ru.yandex.common.util.json.JsonConvertableWithKey;

/**
 * User: Alexey Zakharov <azakharov@yandex-team.ru>
 * Date: 23.01.12
 *
 * Класс позволяет завернуть JsonConvertible в JSONP
 * Предполагается использовать совместно с Jsoner
 */
public final class JsonpBuilder {
    public static void toJsonp(final StringBuilder sb, final String callback, final JsonConvertableWithKey body) {
        sb.append(callback);
        sb.append('(');
        sb.append(body.getKey());
        sb.append('=');
        body.toJson(sb);
        sb.append(')');
    }
}
