package ru.yandex.wmtools.common.util;

import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import ru.yandex.common.framework.core.ServResponse;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * @author avhaliullin
 */
public class MapAndWrapRowCallbackHandler<T> implements RowCallbackHandler {
    private int i = 0;
    private final ParameterizedRowMapper<T> mapper;
    private final WrapperFactory<T> wrapper;
    private final ServResponse res;
    private final Charset charset;

    public MapAndWrapRowCallbackHandler(WrapperFactory<T> wrapper, ParameterizedRowMapper<T> mapper, ServResponse res, Charset charset) {
        this.wrapper = wrapper;
        this.mapper = mapper;
        this.res = res;
        this.charset = charset;
    }

    public MapAndWrapRowCallbackHandler(Class<? extends XmlDataWrapper<T>> wrapper, ParameterizedRowMapper<T> mapper, ServResponse res, Charset charset) {
        this(getFactoryByClass(wrapper), mapper, res, charset);
    }

    private static <T> WrapperFactory<T> getFactoryByClass(final Class<? extends XmlDataWrapper<T>> wrapperClass) {
        return new WrapperFactory<T>() {
            @Override
            public XmlDataWrapper<T> wrap(T data) {
                try {
                    Constructor<?>[] constructors = wrapperClass.getConstructors();
                    Constructor<? extends XmlDataWrapper<T>> correctConstructor = null;
                    for (Constructor<?> constructor : constructors) {
                        if (constructor.getParameterTypes().length == 1
                                && constructor.getParameterTypes()[0].isAssignableFrom(data.getClass())) {
                            correctConstructor = wrapperClass.getConstructor(constructor.getParameterTypes()[0]);
                            break;
                        }
                    }
                    if (correctConstructor == null) {
                        throw new IllegalArgumentException("Cannot find constructor!");
                    }
                    return correctConstructor.newInstance(data);
                } catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("Cannot find constructor!", e);
                } catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Wrong arguments for constructor!", e);
                } catch (InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                } catch (InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
    }

    @Override
    public void processRow(ResultSet rs) throws SQLException {
        StringBuilder sb = new StringBuilder();
        wrapper.wrap(mapper.mapRow(rs, i++)).toXml(sb);
        res.write(sb.toString().getBytes(charset));
    }
}
