package ru.yandex.wmtools.common.util;

import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;

import ru.yandex.wmtools.common.error.InternalException;

/**
 * User: baton
 * Date: 11.10.2007
 * Time: 18:06:46
 */
public class ReadOnlyServiceJdbcTemplate extends ServiceJdbcTemplate implements IServiceJdbcTemplate {
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyServiceJdbcTemplate.class);

    public ReadOnlyServiceJdbcTemplate(DataSource dataSource, String databaseInfo) {
        super(dataSource, databaseInfo);
    }

    @Override
    public JdbcOperations getJdbcOperations() throws InternalException {
        log.debug("getJdbcOperations() is not supported in read-only interface (returned null)");
        return null;
    }

    @Override
    public int update(final String sqlString, final Object... requestParams) throws InternalException {
        log.debug("update() is not supported in read-only interface (returned 0)");
        return 0;
    }

    @Override
    public Number insertSingle(String sqlString, Object... requestParams) throws InternalException {
        log.debug("insertSingle() is not supported in read-only interface (returned null)");
        return null;
    }

}
