package ru.yandex.wmtools.common.util;

import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * User: baton
 * Date: 10.05.2007
 * Time: 20:13:50
 */
public class ServiceTransactionTemplate extends TransactionTemplate {
    public <T> T executeInService(final ServiceTransactionCallback<T> serviceTransactionCallback)
            throws TransactionException, InternalException, UserException {
        try {
            return execute(new TransactionCallback<T>() {
                @Override
                public T doInTransaction(TransactionStatus transactionStatus) {
                    try {
                        return serviceTransactionCallback.doInTransaction(transactionStatus);
                    } catch (UserException e) {
                        throw new RuntimeException(e);
                    } catch (InternalException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        } catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UserException) {
                throw (UserException) cause;
            } else if (cause instanceof InternalException) {
                throw (InternalException) cause;
            } else {
                throw e;
            }
        }
    }
}
