package ru.yandex.wmtools.common.util;

import java.io.IOException;
import java.io.Reader;

/**
 * @author avhaliullin
 */
public class StreamInterceptorReader extends Reader {
    private final Reader reader;
    private final StringBuilder result = new StringBuilder();

    public StreamInterceptorReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int res = reader.read(cbuf, off, len);
        if (res > 0) {
            result.append(cbuf, off, res);
        }
        return res;
    }

    @Override
    public void close() throws IOException {
        reader.close();
    }

    public String getStreamContent() {
        return result.toString();
    }
}
